// ColourView.cpp : implementation file
//

#include "stdafx.h"
#include "pablodraw.h"
#include "ColourView.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CColourView


CColourView::CColourView()
{
    m_pParentFrame = NULL;
    m_bIsVert = FALSE;
	m_bIsSimpleMode = FALSE;
	m_strColour = _T(" Colour ");
}

CColourView::~CColourView()
{
}

CSize CColourView::GetSize(BOOL p_bIsVert)
{
	CSize size(0,0);
	m_bIsVert = p_bIsVert;
    if (m_bIsSimpleMode)
	{
		CPabloDrawDoc* pDoc = GetMainFrame()->GetDocument();
		if (pDoc)
		{
			cPage* pPage = pDoc->GetCurrentPage();
			if (pPage)
			{
				cFont* pFont = pPage->GetFont();
				if (p_bIsVert) 
					size = CSize(pFont->GetSize().cx, pFont->GetSize().cy*(m_strColour.GetLength()+13));
				else
					size = CSize(pFont->GetSize().cx*(m_strColour.GetLength()+13), pFont->GetSize().cy);
			}
		}
	}
	else
	{
		if (p_bIsVert) size = CSize(40,175);
		else size = CSize(175, 40);
	}
	return size;
}

BEGIN_MESSAGE_MAP(CColourView, CWnd)
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_PAINT()
END_MESSAGE_MAP()

void CColourView::DrawString(CDC* pDC, CPoint& p_ptStart, LPCTSTR p_tszValue, tElementPart p_fore, tElementPart p_back)
{
	CString strValue = p_tszValue;
	CPabloDrawDoc* pDoc = GetMainFrame()->GetDocument();
    if (pDoc)
    {
        cPage* pPage = pDoc->GetCurrentPage();
		if (!pPage) return;
		cFont* pFont = pPage->GetFont();
		for (int iCount=0; iCount<strValue.GetLength(); iCount++)
		{
			DrawCharacter(pDC, p_ptStart, strValue.GetAt(iCount), p_fore, p_back);
			p_ptStart += (m_bIsVert) ? CSize(0, pFont->GetSize().cy) : CSize(pFont->GetSize().cx, 0);
		}
	}
}

void CColourView::DrawCharacter(CDC* pDC, CPoint p_ptStart, UCHAR p_ucCharacter, tElementPart p_fore, tElementPart p_back)
{
    CPabloDrawDoc* pDoc = GetMainFrame()->GetDocument();
    if (pDoc)
    {
        cPage* pPage = pDoc->GetCurrentPage();
		if (!pPage) return;
        cPalette* pPal = pPage->GetPalette();
		cFont* pFont = pPage->GetFont();

		CBrush brFore(pPal->GetCol(p_fore));
		CBrush brBack(pPal->GetCol(p_back));
		for (int y=0; y<pFont->GetSize().cy; y++)
		{
			for (int x=0; x<pFont->GetSize().cx; x++)
			{
				CRect rect(p_ptStart + CPoint(x,y) , CSize(1,1));
				if (pFont->GetPoint(p_ucCharacter, CPoint(x,y)))
					pDC->FillRect(rect, &brFore);
				else
					pDC->FillRect(rect, &brBack);

			}
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
// CColourView drawing

void CColourView::OnDraw(CDC* pDC)
{
    CPabloDrawDoc* pDoc = GetMainFrame()->GetDocument();
    if (pDoc)
    {
        cPage* pPage = pDoc->GetCurrentPage();
		if (!pPage) return;
        cCanvas* pCanvas = pPage->GetCanvas();
        cPalette* pPal = pPage->GetPalette();
        CRect rect;

		CBrush brFore(pPal->GetCol(pCanvas->GetFore()));
		CBrush brBack(pPal->GetCol(pCanvas->GetBack()));

		if (m_bIsSimpleMode)
		{
			CPoint ptStart(0,0);
			CString strDisplay;
			static CPoint ptCursor(0,0);
			if (GetFocus()->IsKindOf(RUNTIME_CLASS(CCanvasView)))
			{
				CCanvasView* pCanvasView = (CCanvasView*)GetFocus();
				ptCursor = pCanvasView->GetCursorPosition();

			}
			DrawString(pDC, ptStart, _T("("), 15, 0);
			strDisplay.Format(_T("%4i"), ptCursor.x+1);
			DrawString(pDC, ptStart, strDisplay, 7, 0);

			DrawString(pDC, ptStart, _T(","), 15, 0);

			strDisplay.Format(_T("%4i"), ptCursor.y+1);
			DrawString(pDC, ptStart, strDisplay, 7, 0);
			DrawString(pDC, ptStart, _T(") "), 15, 0);

			DrawString(pDC, ptStart, m_strColour, pCanvas->GetFore(), pCanvas->GetBack());

			DrawString(pDC, ptStart, _T(" "), 7, 0);
		}
		else
		{
			CFont font;
			font.Attach(GetStockObject(DEFAULT_GUI_FONT));
			CFont* pOldFont = pDC->SelectObject(&font);

			int i;
			for (i=0; i<8; i++)
			{
				rect = CRect(0,0,15,15);
				rect += (m_bIsVert) ? CPoint(16+2, 42+i*16) : CPoint(42+i*16, 2);
				pDC->Draw3dRect(rect, ::GetSysColor(COLOR_3DSHADOW), ::GetSysColor(COLOR_3DHILIGHT));
				rect.DeflateRect(CRect(1,1,1,1));
				CBrush br(pPal->GetCol(i));
				pDC->FillRect(rect, &br);
				if (pCanvas->GetFore() == i)
				{
					pDC->SetBkColor(pPal->GetCol(i));
					CRect rectFont = rect;
					rectFont.right = rectFont.left + (rectFont.Width()/2);
					pDC->DrawText(_T("F"), rectFont, DT_VCENTER | DT_CENTER); //Draw3dRect(rect, ::GetSysColor(COLOR_3DSHADOW), ::GetSysColor(COLOR_3DHILIGHT));
				}
				if (pCanvas->GetBack() == i)
				{
					pDC->SetBkColor(pPal->GetCol(i));
					CRect rectFont = rect;
					rectFont.left += rectFont.Width()/2;
					pDC->DrawText(_T("B"), rectFont, DT_VCENTER | DT_CENTER); //Draw3dRect(rect, ::GetSysColor(COLOR_3DSHADOW), ::GetSysColor(COLOR_3DHILIGHT));
				}
			}
			for (i=0; i<8; i++)
			{
				rect = CRect(0,0,15,15);
				rect += (m_bIsVert) ? CPoint(2, 42+i*16) : CPoint(42+i*16, 16+2);
				pDC->Draw3dRect(rect, ::GetSysColor(COLOR_3DSHADOW), ::GetSysColor(COLOR_3DHILIGHT));
				rect.DeflateRect(CRect(1,1,1,1));
				CBrush br(pPal->GetCol(i+8));
				pDC->FillRect(rect, &br);
				if (pCanvas->GetFore() == i+8)
				{
					pDC->SetBkColor(pPal->GetCol(i+8));
					CRect rectFont = rect;
					rectFont.right = rectFont.left + (rectFont.Width()/2);
					pDC->DrawText(_T("F"), rectFont, DT_VCENTER | DT_CENTER); //Draw3dRect(rect, ::GetSysColor(COLOR_3DSHADOW), ::GetSysColor(COLOR_3DHILIGHT));
				}
				if (pCanvas->GetBack() == i+8)
				{
					pDC->SetBkColor(pPal->GetCol(i+8));
					CRect rectFont = rect;
					rectFont.left += rectFont.Width()/2;
					pDC->DrawText(_T("B"), rectFont, DT_VCENTER | DT_CENTER); //Draw3dRect(rect, ::GetSysColor(COLOR_3DSHADOW), ::GetSysColor(COLOR_3DHILIGHT));
				}
			}

			pDC->SelectObject(pOldFont);

			CRect rectFore = CRect(CPoint(2,2), CSize(24,24));
			CRect rectBack = CRect(CPoint(10, 10), CSize(24,24));


			pDC->Draw3dRect(rectFore, ::GetSysColor(COLOR_3DSHADOW), ::GetSysColor(COLOR_3DHILIGHT));
			rectFore.DeflateRect(CRect(1,1,1,1));

			pDC->Draw3dRect(rectBack, ::GetSysColor(COLOR_3DSHADOW), ::GetSysColor(COLOR_3DHILIGHT));
			rectBack.DeflateRect(CRect(1,1,1,1));
			pDC->Draw3dRect(rectBack, RGB(0,0,0), RGB(0,0,0));
			rectBack.DeflateRect(CRect(1,1,1,1));
			pDC->FillRect(rectBack, &brBack);

			pDC->Draw3dRect(rectFore, RGB(0,0,0), RGB(0,0,0));
			rectFore.DeflateRect(CRect(1,1,1,1));
			pDC->FillRect(rectFore, &brFore);
		}
    }
}

/////////////////////////////////////////////////////////////////////////////
// CColourView diagnostics

#ifdef _DEBUG
void CColourView::AssertValid() const
{
	CWnd::AssertValid();
}

void CColourView::Dump(CDumpContext& dc) const
{
	CWnd::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CColourView message handlers

void CColourView::OnLButtonDown(UINT nFlags, CPoint point) 
{
    BOOL bIn = FALSE;
    CPabloDrawDoc* pDoc = GetMainFrame()->GetDocument();
    if (pDoc)
    {
        cPage* pPage = pDoc->GetCurrentPage();
		if (pPage)
		{
			cCanvas* pCanvas = pPage->GetCanvas();
			CRect rect;
			int i;
			for (i=0; i<8; i++)
			{
				rect = CRect(0,0,15,15);
				rect += (m_bIsVert) ? CPoint(16+2, 42+i*16) : CPoint(42+i*16, 2);
				if (rect.PtInRect(point)) { pCanvas->SetFore((UCHAR)i); bIn = TRUE; }
			}
			for (i=0; i<8; i++)
			{
				rect = CRect(0,0,15,15);
				rect += (m_bIsVert) ? CPoint(2, 42+i*16) : CPoint(42+i*16, 16+2);
				if (rect.PtInRect(point)) { pCanvas->SetFore((UCHAR)(i+8)); bIn = TRUE; }
			}
			Invalidate(FALSE);
		}
	}
    if (!bIn) GetParent()->SendMessage(WM_LBUTTONDOWN, nFlags, MAKELPARAM(point.x, point.y));    
	
	CWnd::OnLButtonDown(nFlags, point);
}

void CColourView::OnRButtonDown(UINT nFlags, CPoint point) 
{
    CPabloDrawDoc* pDoc = GetMainFrame()->GetDocument();
    if (pDoc)
    {
        cPage* pPage = pDoc->GetCurrentPage();
		if (pPage)
		{
			cCanvas* pCanvas = pPage->GetCanvas();
			CRect rect;
			int i;
			for (i=0; i<8; i++)
			{
				rect = CRect(0,0,15,15);
				rect += (m_bIsVert) ? CPoint(16+2, 42+i*16) : CPoint(42+i*16, 2);
				if (rect.PtInRect(point)) pCanvas->SetBack((UCHAR)i);
			}
			for (i=0; i<8; i++)
			{
				rect = CRect(0,0,15,15);
				rect += (m_bIsVert) ? CPoint(2, 42+i*16) : CPoint(42+i*16, 16+2);
				if (rect.PtInRect(point)) pCanvas->SetBack((UCHAR)(i+8));
			}
			Invalidate(FALSE);	
		}
	}
	
	CWnd::OnRButtonDown(nFlags, point);
}

void CColourView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
    BOOL bIn = FALSE;
	
    if (!bIn) GetParent()->SendMessage(WM_LBUTTONDBLCLK, nFlags, MAKELPARAM(point.x, point.y));    
	CWnd::OnLButtonDblClk(nFlags, point);
}

BOOL CColourView::PreCreateWindow(CREATESTRUCT& cs) 
{
	// TODO: Add your specialized code here and/or call the base class

    cs.lpszClass = AfxRegisterWndClass(
      CS_DBLCLKS | CS_VREDRAW | CS_HREDRAW,
      ::LoadCursor(NULL, IDC_ARROW),
      ::GetSysColorBrush(COLOR_3DFACE),
      ::LoadIcon(NULL, IDI_APPLICATION));
	
	return CWnd::PreCreateWindow(cs);
}

void CColourView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	OnDraw(&dc);
}
