// PabloDrawDoc.cpp : implementation of the CPabloDrawDoc class
//

#include "stdafx.h"
#include "PabloDraw.h"

#include "cFormat.h"
#include "cFormatAnsi.h"
#include "cFormatBinary.h"
#include "PabloDrawDoc.h"
#include "ServerOptionsDialog.h"
#include "ClientOptionsDialog.h"
#include "cFileDialog.h"

#include "stdio.h"
#include "stdlib.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CPabloDrawDoc

IMPLEMENT_DYNCREATE(CPabloDrawDoc, CDocument)

BEGIN_MESSAGE_MAP(CPabloDrawDoc, CDocument)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_FILE_SEND_MAIL, OnFileSendMail)
	ON_UPDATE_COMMAND_UI(ID_FILE_SEND_MAIL, OnUpdateFileSendMail)
//	ON_COMMAND(ID_FILE_NEW, OnFileNew)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPabloDrawDoc construction/destruction



CPabloDrawDoc::CPabloDrawDoc()
{
#ifdef USE_THREADED_CLIENT	
    m_pClientThread = NULL;
#else
	m_pClientSocket = NULL;
#endif
	m_pListeningSocket = NULL;
	m_pListeningSocketThread = NULL;

	m_iCurrentCharSet = 5;
}

CPabloDrawDoc::CPabloDrawDoc(CPabloDrawDoc* pDoc)
{
	m_iCurrentCharSet = pDoc->m_iCurrentCharSet;
	POSITION pos = pDoc->m_pageList.GetHeadPosition();
	m_pageList.RemoveAll();
	while (pos)
	{
		cPage* p = pDoc->m_pageList.GetNext(pos);
		cPage* pNew = new cPage(GetApp()->GetOptions(), p->GetCanvas()->GetSize());
		pNew->GetCanvas()->Set(p->GetCanvas());
		m_pageList.AddTail(pNew);
	}
}

CPabloDrawDoc::~CPabloDrawDoc()
{
	while (!m_pageList.IsEmpty())
	{
		delete m_pageList.GetHead();
		m_pageList.RemoveHead();
	}
}

BOOL CPabloDrawDoc::OnNewDocument()
{
	return OnNewDocument(CSize(0,0));
}

BOOL CPabloDrawDoc::OnNewDocument(CSize p_sizeCanvas)
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	SetTitle(NULL);
	SetModifiedFlag(FALSE);
	while (!m_pageList.IsEmpty())
	{
		delete m_pageList.GetHead();
		m_pageList.RemoveHead();
	}
    cPage* pPage = new cPage(GetApp()->GetOptions(), p_sizeCanvas);
    m_pageList.AddTail(pPage);

	cCanvas* pCanvas = pPage->GetCanvas();
	CClientSocket* pSocket = GetClientSocket();
	if (pSocket) pSocket->Clear(pCanvas); // clear all users
	if (pSocket) pSocket->ClearFile();

	UpdateAllViews(NULL);
	return TRUE;
}


void CPabloDrawDoc::SendMessage(UINT message, WPARAM wparam, LPARAM lparam)
{
    POSITION pos;

    pos = GetFirstViewPosition();

    while (pos)
    {
        CView* pView = GetNextView(pos);
		pView->SendMessage(message, wparam, lparam);
    }
}

void CPabloDrawDoc::PostMessage(UINT message, WPARAM wparam, LPARAM lparam)
{
    POSITION pos;

    pos = GetFirstViewPosition();

    while (pos)
    {
        CView* pView = GetNextView(pos);
		pView->PostMessage(message, wparam, lparam);
    }
}

void CPabloDrawDoc::UpdateRegion(CRect& rect, CCanvasView* pCurView)
{
    POSITION pos;

    pos = GetFirstViewPosition();

    while (pos)
    {
        CView* pView = GetNextView(pos);
        if (pView->IsKindOf(RUNTIME_CLASS(CCanvasView)))
        {
            CCanvasView* pCanvasView = (CCanvasView*)pView;
            if (pCurView != pCanvasView) pCanvasView->UpdateRegion(rect);
        }
    }
}
void CPabloDrawDoc::UpdateRegion(CRectArray& arrRect, CCanvasView* pCurView)
{
	for (int i=0; i<arrRect.GetCount(); i++)
	{
		UpdateRegion(arrRect.GetAt(i), pCurView);
	}
}

void CPabloDrawDoc::DeleteClient(BOOL p_bRemoveFromServer)
{
#ifdef USE_THREADED_CLIENT	
    if (m_pClientThread)
    {
		CClientSocketThread* pClientThread = m_pClientThread;
        m_pClientThread = NULL;
        pClientThread->m_bRemoveFromServer = p_bRemoveFromServer;
		pClientThread->PostThreadMessage(WM_QUIT, 0, 0);
    }
#else
	if (m_pClientSocket)
	{
		if (p_bRemoveFromServer) m_pClientSocket->Remove();
		delete m_pClientSocket;
		m_pClientSocket = NULL;
	}
#endif
	SendMessage(WM_USER_PARTED, (WPARAM)0); // clear all
}

/////////////////////////////////////////////////////////////////////////////
// CPabloDrawDoc serialization

void CPabloDrawDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		 // TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CPabloDrawDoc diagnostics

#ifdef _DEBUG
void CPabloDrawDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CPabloDrawDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


BOOL CPabloDrawDoc::LoadFile(LPCTSTR tszFilename)
{
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

	CFile file;
    if (file.Open(tszFilename, CFile::modeRead))
	{

		//CString str = CFile::GetFileName();
/*
		while (!m_pageList.IsEmpty())
		{
			delete m_pageList.GetHead();
			m_pageList.RemoveHead();
		}
*/	    
	    CClientSocket* pSocket = GetClientSocket();

		tPageList* pPageList = (pSocket) ? new tPageList() : &m_pageList;

		cPage* pPage;
		if (!pSocket)
		{
			pPage = GetCurrentPage();
			if (pPage) pPage->GetCanvas()->Fill(7,32);
		}

		cFormat* pFormat = pApp->GetFormat(tszFilename, FMT_LOAD);
		if (pFormat) pFormat->Load(&file, pPageList, GetApp()->GetOptions());

		if (pSocket) pPage = pPageList->GetHead();

		file.Close();
		if (pPage == NULL) 
		{
			AfxMessageBox("Error loading file");
			return FALSE;
		}
		SetPathName(tszFilename);
		UpdateAllViews(NULL);

        cCanvas* pCanvas = pPage->GetCanvas();
        CRect rect = CRect(0, 0, pCanvas->GetSize().cx, pCanvas->FindEndY()+1);

		if (pSocket)
		{
			pSocket->UndoCombine(1);
			pSocket->Clear(pCanvas);
			pSocket->ClearFile();
		}
        if (rect.bottom > 0)
        {
			if (pSocket) pSocket->SendPart(pCanvas, rect);
        }
		if (pSocket) delete pPageList;

        SetModifiedFlag(FALSE);

	}
	else
	{
		AfxMessageBox(_T("Could not load file!"), MB_OK | MB_ICONERROR);
		return FALSE;
	}
    return TRUE;
}
BOOL CPabloDrawDoc::OnOpenDocument(LPCTSTR lpszPathName)
{
	return LoadFile(lpszPathName);
}


BOOL CPabloDrawDoc::OnSaveDocument(LPCTSTR lpszPathName)
{
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();

	CString strFile = lpszPathName;

	if (strFile.Find('.') == -1) strFile += _T(".ans");
	CFile file;
    file.Open(strFile, CFile::modeCreate | CFile::modeWrite);


    cFormat* pFormat = pApp->GetFormat(strFile, FMT_SAVE);
	if (pFormat)
	{
		pFormat->Save(&file, &m_pageList, GetApp()->GetOptions());
	}

    file.Flush();
    file.Close();
	SetPathName(strFile);

	return TRUE;
}

void CPabloDrawDoc::OnFileSaveAs()
{
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();
    CString strFormat = pApp->GetFormatString(FMT_SAVE);

	cFileDialog fd(FALSE, NULL, NULL, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT | OFN_ENABLESIZING, strFormat);
    if (fd.DoModal() == IDOK)
    {
        if (OnSaveDocument(fd.GetPathName()))
		{
			SetModifiedFlag(FALSE);
		}
    }
}
void CPabloDrawDoc::SetPathName(LPCTSTR lpszPathName, BOOL bAddToMRU)
{
	if (lpszPathName == NULL)
	{
		m_strPathName.Empty();
		SetTitle(NULL);
		//CDocument::OnNewDocument();
	}
	else CDocument::SetPathName(lpszPathName, bAddToMRU);
}

void CPabloDrawDoc::OnFileSave()
{
	CPabloDrawApp* pApp = (CPabloDrawApp*)AfxGetApp();
	CString strFile = GetPathName();
	if (strFile.IsEmpty())
	{
		CString strFormat = pApp->GetFormatString(FMT_SAVE);

		cFileDialog fd(FALSE, NULL, NULL, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT | OFN_ENABLESIZING, strFormat);
		
		if (fd.DoModal() == IDOK)
		{
			if (OnSaveDocument(fd.GetPathName()))
			{
				SetModifiedFlag(FALSE);
			}
		}
	}
	else
	{
		if (OnSaveDocument(strFile))
		{
			SetModifiedFlag(FALSE);
		}
	}

}


void CPabloDrawDoc::OnCloseDocument()
{
	while (!m_pageList.IsEmpty()) delete m_pageList.RemoveHead();

    OnCanvasBreakconnection();

    CDocument::OnCloseDocument();

}

void CPabloDrawDoc::OnCanvasBreakconnection()
{
	if (!CheckDisconnect()) return;
	DeleteClient();
	if (m_pListeningSocket)
	{
		CEvent ev;
		ev.ResetEvent();
//        ev.SetEvent()
        // disconnects all and nulls the pointer afterwards.
        m_pListeningSocket->DisconnectAll(&ev);

        //ev.Lock(); // wait till we are done!
		m_pListeningSocketThread->PostThreadMessage(WM_QUIT, 0, 0);
		m_pListeningSocketThread = NULL;
		m_pListeningSocket = NULL;
		CSingleLock(&m_eventDone, TRUE);
	}
}


void CPabloDrawDoc::OnCanvasStartserver()
{

	BOOL	bIsOk = TRUE;
    CServerOptionsDialog sod;

    sod.m_uiPort = 700;
	sod.m_strAlias = GetApp()->GetOptions()->GetDefaultAlias();

    if (sod.DoModal() == IDOK)
    {
        GetApp()->GetOptions()->SetDefaultAlias(sod.m_strAlias);

		WSAData wsadata;
		if (!AfxSocketInit(&wsadata))
		{
			AfxMessageBox("Socket initialization failed!");
			return;
		}

		m_pListeningSocketThread = (CListeningSocketThread*)AfxBeginThread(RUNTIME_CLASS(CListeningSocketThread), THREAD_PRIORITY_NORMAL, 0, CREATE_SUSPENDED);
		if (m_pListeningSocketThread)
		{
			BOOL bIsOk = FALSE;
			m_pListeningSocketThread->m_pEventDone = &m_eventDone;
			m_pListeningSocketThread->m_pEventDoneInit = &m_eventDoneInit;
			m_pListeningSocketThread->m_uiPort = sod.m_uiPort;
			m_pListeningSocketThread->m_pDoc = new CPabloDrawDoc(this);
			m_pListeningSocketThread->m_pIsOk = &bIsOk;
			m_pListeningSocketThread->ResumeThread();
			CSingleLock slDoneInit(&m_eventDoneInit, TRUE);

			if (bIsOk) //->Create(sod.m_uiPort))
			{
				m_pListeningSocket = m_pListeningSocketThread->m_pListeningSocket;

				//if (m_pListeningSocket->Listen())
				{
	#ifdef USE_THREADED_CLIENT	
					bIsOk = FALSE;
					m_pClientThread = (CClientSocketThread*)AfxBeginThread(RUNTIME_CLASS(CClientSocketThread), THREAD_PRIORITY_NORMAL, 0, CREATE_SUSPENDED);
					m_eventDoneInit.ResetEvent();
					m_pClientThread->m_pEventDoneInit = &m_eventDoneInit;
					m_pClientThread->m_pDoc = this;
					m_pClientThread->m_strAlias = sod.m_strAlias;
					m_pClientThread->m_uiPort = sod.m_uiPort;
					m_pClientThread->m_strIP = _T("localhost");
					m_pClientThread->m_pIsOk = &bIsOk;
					m_pClientThread->ResumeThread();
					CSingleLock sl(&m_eventDoneInit, TRUE);
					if (!bIsOk)
					{
						AfxMessageBox("Unable to connect to server!");
						m_pClientThread = NULL;
						bIsOk = FALSE;
					}
	#else
					m_pClientSocket = new CClientSocket(this, sod.m_strAlias);
					if (m_pClientSocket->Create())
					{
						if (m_pClientSocket->Connect("localhost",sod.m_uiPort))
						{
							m_pClientSocket->Init();
							m_pClientSocket->ClearFile();
						}
						else
						{
							bIsOk = FALSE;
							AfxMessageBox("Unable to connect to server!");
						}
					}
					else
					{
						bIsOk = FALSE;
						AfxMessageBox("Unable to create client socket!");
					}
	#endif
				}
				//else
				{
				//	bIsOk = FALSE;
				//	AfxMessageBox("Cannot start listening socket!");
				}
			}
			else
			{
				bIsOk = FALSE;
				AfxMessageBox("Unable to create listening socket!");
			}
		}
		else
		{
				bIsOk = FALSE;
				AfxMessageBox("Unable to create listening thread!");
		}
    }
	if (!bIsOk)
	{
#ifndef USE_THREADED_CLIENT
		if (m_pClientSocket) delete m_pClientSocket;
		m_pClientSocket = NULL;
#endif
//		if (m_pListeningSocket) delete m_pListeningSocket;
		if (m_pListeningSocketThread)
		{
			
			m_pListeningSocketThread->PostThreadMessage(WM_QUIT, 0, 0);
			CSingleLock(&m_eventDone, TRUE);
		}
		//m_pListeningSocketThread->Delete(
		m_pListeningSocket = NULL;

	}

}

void CPabloDrawDoc::OnCanvasConnecttoserver()
{
    static UINT uiPort = 700;
    static CString strIP;
    CClientOptionsDialog cod;

    cod.m_uiPort = uiPort;
    cod.m_strAlias = GetApp()->GetOptions()->GetDefaultAlias();
    cod.m_strIP = strIP;

    if (cod.DoModal() == IDOK)
    {
        GetApp()->GetOptions()->SetDefaultAlias(cod.m_strAlias);
		strIP = cod.m_strIP;
		uiPort = cod.m_uiPort;
#ifdef USE_THREADED_CLIENT	
		BOOL bIsOk = FALSE;
		m_pClientThread = (CClientSocketThread*)AfxBeginThread(RUNTIME_CLASS(CClientSocketThread), THREAD_PRIORITY_NORMAL, 0, CREATE_SUSPENDED);
		m_pClientThread->m_pEventDoneInit = &m_eventDoneInit;
		m_pClientThread->m_pDoc = this;
		m_pClientThread->m_strAlias = cod.m_strAlias;
		m_pClientThread->m_uiPort = cod.m_uiPort;
		m_pClientThread->m_strIP = cod.m_strIP;
		m_pClientThread->m_pIsOk = &bIsOk;
		m_pClientThread->ResumeThread();
		CSingleLock sl(&m_eventDoneInit, TRUE);
		if (!bIsOk)
		{
			AfxMessageBox("Unable to connect to server!");
			m_pClientThread = NULL;
		}
#else
        m_pClientSocket = new CClientSocket(this, cod.m_strAlias);
        if (m_pClientSocket->Create())
        {
            if (m_pClientSocket->Connect(cod.m_strIP,cod.m_uiPort))
            {
                m_pClientSocket->Init();
            }
            else
            {
                delete m_pClientSocket;
                m_pClientSocket = NULL;
                AfxMessageBox("Unable to connect to server!");
            }
        }
        else
        {
            delete m_pClientSocket;
            m_pClientSocket = NULL;
            AfxMessageBox("Unable to connect to server!");
        }
#endif
    }
}

void CPabloDrawDoc::OnUpdateCanvasBreakconnection(CCmdUI* pCmdUI)
{
#ifdef USE_THREADED_CLIENT	
    pCmdUI->Enable(m_pClientThread != NULL);
#else
    pCmdUI->Enable(m_pClientSocket != NULL);
#endif
}

void CPabloDrawDoc::OnUpdateCanvasConnecttoserver(CCmdUI* pCmdUI)
{
#ifdef USE_THREADED_CLIENT	
    pCmdUI->Enable(m_pClientThread == NULL);
#else
    pCmdUI->Enable(m_pClientSocket == NULL);
#endif
}

void CPabloDrawDoc::OnUpdateCanvasStartserver(CCmdUI* pCmdUI)
{
#ifdef USE_THREADED_CLIENT	
    pCmdUI->Enable(m_pListeningSocket == NULL && m_pClientThread == NULL);
#else
    pCmdUI->Enable(m_pListeningSocket == NULL && m_pClientSocket == NULL);
#endif
}

BOOL CPabloDrawDoc::CheckDisconnect()
{
	if (m_pListeningSocket && m_pListeningSocket->GetNumUsers() > 1)
	{
		CString str;
		str.Format(_T("You currently have %i user(s) connected to your server.\nAre you sure you want to close and disconnect all users?"), m_pListeningSocket->GetNumUsers()-1);
		if (AfxMessageBox(str, MB_ICONQUESTION | MB_OKCANCEL | MB_DEFBUTTON2) == IDCANCEL)
		{
			return FALSE;
		}
	}
	return TRUE;
}

BOOL CPabloDrawDoc::SaveModified()
{
	if (!CheckDisconnect()) return FALSE;
	return CDocument::SaveModified();
}

//void CPabloDrawDoc::OnFileNew()
//{
//	OnNewDocument();
//}
