#pragma once

const LONG MENUID_SUBMENU = -1;
const LONG MENUID_SEPARATOR = -2;

class cMenuItemList;



class cCommand
{
public:
    cCommand
        (
            LONG			p_lID = -1, 
            DWORD           p_dwImageID = 0,                // id of the bitmap to use for this image
            DWORD           p_dwDisabledImageID = 0,        // id of the bitmap to use for this image
            DWORD           p_dwHotImageID = 0,             // id of the bitmap to use for this image
			BOOL			p_bShowSelective = FALSE,
            LPCTSTR			p_tszText = NULL            // menu text
        );

    cCommand
        (
            LONG            p_lID, 
            DWORD           p_dwImageID,                    // id of the bitmap to use for this image
            DWORD           p_dwDisabledImageID,            // id of the bitmap to use for this image
            DWORD           p_dwHotImageID,                 // id of the bitmap to use for this image
			BOOL    		p_bShowSelective,
            LPCTSTR         p_tszMenuText,                  // menu text
            LPCTSTR         p_tszButtonText,                // toolbar button text
            LPCTSTR         p_tszToolTip = NULL,        // tooltip text
            LPCTSTR         p_tszHelpText = NULL        // status bar text
        );

    cCommand(const cCommand& p_value);

    const cCommand&   operator=(const cCommand& p_value);

    void Set(const cCommand& p_value);

    void Set
        (
            LONG            p_lID = -1, 
            DWORD           p_dwImageID = 0,                // id of the bitmap to use for this image
            DWORD           p_dwDisabledImageID = 0,        // id of the bitmap to use for this image
            DWORD           p_dwHotImageID = 0,             // id of the bitmap to use for this image
			BOOL    		p_bShowSelective = FALSE,
            LPCTSTR         p_tszText = NULL            // menu text
        );

    void Set
        (
            LONG            p_lID, 
            DWORD           p_dwImageID,                    // id of the bitmap to use for this image
            DWORD           p_dwDisabledImageID,            // id of the bitmap to use for this image
            DWORD           p_dwHotImageID,                 // id of the bitmap to use for this image
			BOOL    		p_bShowSelective,
            LPCTSTR         p_tszMenuText,                  // menu text
            LPCTSTR         p_tszButtonText,                // toolbar button text
            LPCTSTR         p_tszToolTip = NULL,        // tooltip text
            LPCTSTR         p_tszHelpText = NULL        // status bar text
        );


    void SetID(LONG     p_lID)  { m_lID = p_lID; }
    void SetText(LPCTSTR    p_tszText);
    void SetMenuText(LPCTSTR    p_tszMenuText)  { m_strMenuText = p_tszMenuText; }
    void SetButtonText(LPCTSTR    p_tszButtonText) { m_strButtonText = p_tszButtonText; }
    void SetToolTip(LPCTSTR    p_tszToolTip) { m_strToolTip = p_tszToolTip; }
    void SetHelpText(LPCTSTR    p_tszHelpText) { m_strHelpText = p_tszHelpText; }
	void SetAccelerator(LPCTSTR p_tszAccelerator) { m_strAccelerator = p_tszAccelerator; }
    void SetImageID(DWORD p_dwImageID) { m_dwImageID = p_dwImageID; }
    void SetDisabledImageID(DWORD p_dwDisabledImageID) { m_dwDisabledImageID = p_dwDisabledImageID; }
    void SetHotImageID(DWORD p_dwHotImageID) { m_dwHotImageID = p_dwHotImageID; }
	void SetShowSelective(BOOL     p_bShowSelective) { m_bShowSelective = p_bShowSelective; }
    
    LONG                GetID() const           { return m_lID; }
    const CString 		GetMenuText() const     
		{
			CString str = m_strMenuText;
			if (!m_strAccelerator.IsEmpty()) str += _T("\t") + m_strAccelerator; 
			return str;
		}
    const CString 		GetButtonText() const   { return m_strButtonText; }
    const CString		GetToolTip() const      
		{
			CString str = m_strToolTip;
			if (!m_strAccelerator.IsEmpty()) str += _T(" (") + m_strAccelerator + _T(")"); 
			return str;
		}
    const CString		GetHelpText() const     { return m_strHelpText; }
	const CString		GetAccelerator() const		{ return m_strAccelerator; }
    DWORD               GetImageID() const			{ return m_dwImageID; }
    DWORD               GetDisabledImageID() const  { return m_dwDisabledImageID; }
    DWORD               GetHotImageID() const		{ return m_dwHotImageID; }
	BOOL    			ShowSelective() const	{ return m_bShowSelective; }

private:
    LONG            m_lID;
    CString      m_strMenuText;
    CString      m_strButtonText;
    CString      m_strToolTip;
    CString      m_strHelpText;
	CString			m_strAccelerator;
    DWORD           m_dwImageID;
    DWORD           m_dwDisabledImageID;
    DWORD           m_dwHotImageID;
    BOOL    		m_bShowSelective;
};

typedef CList<cCommand, const cCommand&> cCommandListBase;

class cCommandList : public cCommandListBase
{
public:
    cCommandList(HACCEL p_hAccel = NULL)
    {
        m_hAccel = p_hAccel;
    }

	cCommandList(const cCommandList& p_value)
	{
		AddTail((cCommandListBase*)&p_value);
		m_hAccel = p_value.m_hAccel;
	}

    void	SetAccelerators(HACCEL p_hAccel, BOOL p_bUpdateItems = TRUE, BOOL p_bAppend = FALSE);

    const cCommand* FindCommand(LONG     p_lID) const
    {
        POSITION pos = GetHeadPosition();
        while (pos)
        {
            const cCommand& command = GetNext(pos);
            if (command.GetID() == p_lID)
            {
                return &command;
            }
        }
        return NULL;
    }

private:
    virtual void    CopyData(cCommand& p_Dest, const cCommand& p_Source);
    void            AddAccelerators(cCommand& p_Dest, BOOL p_bAppend);

    HACCEL      m_hAccel;

};


class cMenuItem
{
public:
    cMenuItem
        (
            LONG     p_lID = -1, 
            BOOL     p_bShowText = FALSE,
            LPCTSTR     p_tszSubMenuText = NULL,
            const cMenuItemList* p_listSubMenu = NULL
        );

    cMenuItem(const cMenuItem& p_value);

    ~cMenuItem();

    void Set
        (
            LONG     p_lID = -1, 
            BOOL     p_bShowText = FALSE,
            LPCTSTR     p_tszSubMenuText = NULL,
            const cMenuItemList* p_listSubMenu = NULL
        );

    void                        Set(const cMenuItem& p_value);
    const cMenuItem&      operator=(const cMenuItem& p_value) { Set(p_value); return *this; }

    void                        SetID(LONG     p_lID) { m_lID = p_lID; }
    void                        SetSubMenuText(LPCTSTR    p_tszSubMenuText) { m_command.SetText(p_tszSubMenuText); }
    void                        SetSubMenu(const cMenuItemList* p_listSubMenu);
    void                        SetShowText(BOOL     p_bShowText) { m_bShowText = p_bShowText; }

    LONG                        GetID() const { return m_lID; }
    const CString           GetSubMenuText() const { return m_command.GetMenuText(); }
    const cMenuItemList*  GetSubMenu() const { return m_plistSubMenu; }
    cMenuItemList*        GetSubMenu() { return m_plistSubMenu; }
    const cCommand*       GetCommand() const { return &m_command; }
    cCommand*             GetCommand() { return &m_command; }
    BOOL                        ShowText() const { return m_bShowText; }

private:
    LONG                        m_lID;
    cCommand              m_command;          // if ID == MENUID_SUBMENU, use this for menu holder
    cMenuItemList*        m_plistSubMenu;
    BOOL                        m_bShowText;
};



typedef CList<cMenuItem, const cMenuItem&> cMenuItemListBase;
class cMenuItemList : public cMenuItemListBase
{
public:
    cMenuItemList(cCommandList* p_plistCommands = NULL, BOOL     p_bCopyCommands = FALSE)
    {
        m_bIsCommandsCopied = p_bCopyCommands;
        m_plistCommands = (m_bIsCommandsCopied && p_plistCommands) ? new cCommandList(*p_plistCommands) : p_plistCommands;
    }

    cMenuItemList(const cMenuItemList& p_value)
    {
		AddHead((cMenuItemListBase*)&p_value);
        m_bIsCommandsCopied = p_value.m_bIsCommandsCopied;
        m_plistCommands = (m_bIsCommandsCopied && p_value.m_plistCommands) ? new cCommandList(*p_value.m_plistCommands) : p_value.m_plistCommands;
    }
    
    ~cMenuItemList()
    {
        if (m_bIsCommandsCopied && m_plistCommands) delete m_plistCommands;
    }

    cMenuItemList& operator=(const cMenuItemList& p_value)
    {
        if (this != &p_value)
        {
            if (m_bIsCommandsCopied && m_plistCommands) delete m_plistCommands;
            m_bIsCommandsCopied = p_value.m_bIsCommandsCopied;
            m_plistCommands = (m_bIsCommandsCopied && p_value.m_plistCommands) ? new cCommandList(*p_value.m_plistCommands) : p_value.m_plistCommands;
			RemoveAll();
			cMenuItemListBase::AddTail((cMenuItemListBase*)&p_value);
        }
        return *this;
    }


    void SetCommandList(cCommandList* p_plistCommands, BOOL     p_bCopyCommands = FALSE)
    {
        if (m_bIsCommandsCopied && m_plistCommands) delete m_plistCommands;
        m_bIsCommandsCopied = p_bCopyCommands;
        m_plistCommands = (m_bIsCommandsCopied && p_plistCommands) ? new cCommandList(*p_plistCommands) : p_plistCommands;
    }

    cCommandList* GetCommandList() { return m_plistCommands; }
    const cCommandList* GetCommandList() const { return m_plistCommands; }

private:
    cCommandList*     m_plistCommands;
    BOOL                    m_bIsCommandsCopied;

};


/*----------------------------------------------------------------------------
 *  Name:           cMenu
 *  Purpose:        used to create menu dynamically
 *----------------------------------------------------------------------------
 */
class cMenu : public CMenu
{
public:
    cMenu();
    virtual ~cMenu();

    const cCommand*   GetCommand(LONG     p_lID) const { return m_listCommands.FindCommand(p_lID); }

    BOOL                    AddMenu(const cMenuItemList* p_plistMenuItems); // add menu to temp menu

private:
    BOOL ConvertMenu
        (
            CMenu& p_menu,
            const cMenuItemList* p_plistMenuItems
        );


    cCommandList    m_listCommands;

};



