using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Reflection;
using System.IO;
using SimpleXB.Drawing;


namespace SimpleXB
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.MenuItem menuItem43;
		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.StatusBarPanel sbpAuthor;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItem9;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.MenuItem miDefaultPalette;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem miAbout;
		private System.Windows.Forms.StatusBarPanel sbpGroup;
		private System.Windows.Forms.MenuItem miDefaultFont;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		CanvasEdit cv;

		public MainForm(string filename)
		{
			cv = new CanvasEdit();
			cv.AutoScroll = true;
			cv.Dock = DockStyle.Fill;
			cv.TabIndex = 1;
			this.Controls.Add(cv);

			Size s = cv.Page.PixelSize;

			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			cv.Focus();

			VScrollBar vsb = new VScrollBar();
			this.ClientSize = new Size(s.Width+vsb.Width, this.ClientSize.Height);

			Assembly asm = Assembly.GetExecutingAssembly();
			string resourceName = "SimpleXB.ico";
#if !SHARPDEVELOP
			resourceName = asm.GetName().Name + "." + resourceName;
#endif			
			Stream iconStream = asm.GetManifestResourceStream(resourceName);
			Icon i = new Icon(iconStream);
			this.Icon = i;

			if (filename != string.Empty)
			{
				LoadFile(filename); // load the file
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.miDefaultFont = new System.Windows.Forms.MenuItem();
			this.sbpGroup = new System.Windows.Forms.StatusBarPanel();
			this.miAbout = new System.Windows.Forms.MenuItem();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.miDefaultPalette = new System.Windows.Forms.MenuItem();
			this.menuItem8 = new System.Windows.Forms.MenuItem();
			this.menuItem9 = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.sbpAuthor = new System.Windows.Forms.StatusBarPanel();
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.menuItem43 = new System.Windows.Forms.MenuItem();
			((System.ComponentModel.ISupportInitialize)(this.sbpGroup)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.sbpAuthor)).BeginInit();
			this.SuspendLayout();
			// 
			// miDefaultFont
			// 
			this.miDefaultFont.Index = 0;
			this.miDefaultFont.Text = "Default &Font";
			this.miDefaultFont.Click += new System.EventHandler(this.miDefaultFont_Click);
			// 
			// sbpGroup
			// 
			this.sbpGroup.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
			this.sbpGroup.MinWidth = 150;
			this.sbpGroup.ToolTipText = "Group";
			this.sbpGroup.Width = 150;
			// 
			// miAbout
			// 
			this.miAbout.Index = 0;
			this.miAbout.Text = "&About Simple XB...";
			this.miAbout.Click += new System.EventHandler(this.miAbout_Click);
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem1,
						this.menuItem3,
						this.menuItem43});
			// 
			// miDefaultPalette
			// 
			this.miDefaultPalette.Index = 1;
			this.miDefaultPalette.Text = "Default &Palette";
			this.miDefaultPalette.Click += new System.EventHandler(this.miDefaultPalette_Click);
			// 
			// menuItem8
			// 
			this.menuItem8.Index = 4;
			this.menuItem8.Text = "Font...";
			this.menuItem8.Click += new System.EventHandler(this.menuItem8_Click);
			// 
			// menuItem9
			// 
			this.menuItem9.Index = 5;
			this.menuItem9.Text = "Palette...";
			this.menuItem9.Click += new System.EventHandler(this.menuItem9_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 2;
			this.menuItem4.Text = "-";
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 0;
			this.menuItem5.Text = "&Load...";
			this.menuItem5.Click += new System.EventHandler(this.menuItem5_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 1;
			this.menuItem6.Text = "-";
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem5,
						this.menuItem6,
						this.menuItem2});
			this.menuItem1.Text = "&File";
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 2;
			this.menuItem2.Text = "E&xit";
			this.menuItem2.Click += new System.EventHandler(this.menuItem2_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 1;
			this.menuItem3.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.miDefaultFont,
						this.miDefaultPalette,
						this.menuItem4,
						this.menuItem7,
						this.menuItem8,
						this.menuItem9});
			this.menuItem3.Text = "&View";
			// 
			// menuItem7
			// 
			this.menuItem7.Index = 3;
			this.menuItem7.Text = "&Sauce Info...";
			this.menuItem7.Click += new System.EventHandler(this.menuItem7_Click);
			// 
			// sbpAuthor
			// 
			this.sbpAuthor.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
			this.sbpAuthor.ToolTipText = "Author";
			this.sbpAuthor.Width = 346;
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 394);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
						this.sbpGroup,
						this.sbpAuthor});
			this.statusBar1.ShowPanels = true;
			this.statusBar1.Size = new System.Drawing.Size(512, 22);
			this.statusBar1.TabIndex = 0;
			this.statusBar1.Text = "statusBar1";
			// 
			// menuItem43
			// 
			this.menuItem43.Index = 2;
			this.menuItem43.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.miAbout});
			this.menuItem43.Text = "&Help";
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(512, 416);
			this.Controls.Add(this.statusBar1);
			this.Menu = this.mainMenu1;
			this.Name = "MainForm";
			this.Text = "Simple XB";
			((System.ComponentModel.ISupportInitialize)(this.sbpGroup)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.sbpAuthor)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static int Main(string[] args) 
		{
			Application.Run(new MainForm((args.Length >= 1) ? args[0] : string.Empty));
			return 0;
		}

		private void menuItem2_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void menuItem5_Click(object sender, System.EventArgs e)
		{
			// load a file
			OpenFileDialog ofd = new OpenFileDialog();
			ofd.CheckFileExists = true;
			ofd.CheckPathExists = true;
			ofd.Filter = "XBIN Files (*.xb)|*.xb";
			ofd.DefaultExt = "xb";
			ofd.Multiselect = false;
			if (ofd.ShowDialog(this) == DialogResult.OK)
			{
				LoadFile(ofd.FileName);
			}
		}

		private void LoadFile(string filename)
		{
			cv.Page.Load(filename);
			Sauce.Sauce sauce = cv.Page.Sauce;
			if (sauce != null)
			{
				this.Text = string.Format("{0} ({1}) - SimpleXB", Path.GetFileName(filename), sauce.Title);
				sbpGroup.Text = string.Format("Group: {0}", sauce.Group);
				sbpAuthor.Text = string.Format("Author: {0}", sauce.Author);
			}
			else
			{
				this.Text = string.Format("{0} - SimpleXB", Path.GetFileName(filename));
				sbpGroup.Text = string.Empty;
				sbpAuthor.Text = string.Empty;
			}


			cv.Invalidate();
		}

		private void miAbout_Click(object sender, System.EventArgs e)
		{
			About a = new About();
			a.StartPosition = FormStartPosition.CenterParent;
			a.ShowDialog(this);
			
		}

		private void miDefaultPalette_Click(object sender, System.EventArgs e)
		{
			if (cv.CustomPalette != null) cv.CustomPalette = null;
			else cv.CustomPalette = Palette.GetDefaultPalette();
			cv.Invalidate();
			miDefaultPalette.Checked = (cv.CustomPalette != null);
		}

		private void miDefaultFont_Click(object sender, System.EventArgs e)
		{
			if (cv.CustomFont != null) cv.CustomFont = null;
			else 
			{
				if (cv.Page.Font.Height == 8) cv.CustomFont = SimpleXB.Drawing.Font.GetStandard8x8();
				else cv.CustomFont = SimpleXB.Drawing.Font.GetStandard8x16();
			}
			cv.Invalidate();
			miDefaultFont.Checked = (cv.CustomFont != null);
		}

		private void menuItem7_Click(object sender, System.EventArgs e)
		{
			if (cv.Page.Sauce != null)
			{
				SauceInfo si = new SauceInfo(cv.Page.Sauce);
				si.StartPosition = FormStartPosition.CenterParent;
				si.ShowDialog(this);
			}
		}

		private void menuItem8_Click(object sender, System.EventArgs e)
		{
			CharacterSetViewer csv = new CharacterSetViewer(cv.Page);
			csv.StartPosition = FormStartPosition.CenterParent;
			csv.ShowDialog(this);
		}

		private void menuItem9_Click(object sender, System.EventArgs e)
		{
			ColourViewer clv = new ColourViewer(cv.Page);
			clv.StartPosition = FormStartPosition.CenterParent;
			clv.ShowDialog(this);
		}

	}
}
