using System;

namespace SimpleXB.Sauce
{
	public enum CharacterFileType
	{
		Ascii = 0,		/* Plain text file with no formatting codes or color codes. 
						 * TInfo1 is used for the width of the file. 
						 * TInfo2 is used to hold the number of lines in the file.
						 */
		Ansi = 1,		/* ANSi file. With ANSi color codes and cursor positioning. 
						 * TInfo1 is used for the width of the file. 
						 * TInfo2 is used to hold the number of ANSi screen lines in the file. 
						 */
		Ansimation = 2,	/* ANSi Animation. With ANSi color codes and cursor positioning. 
						 * While an ANSi file can also have animated sequences, there is a 
						 * clear distinction. While an ANSi may or may not have a beginning 
						 * animated sequence introducing the group or artist the rest is just a 
						 * sequence of colored characters. An ANSiMation on the other hand is 
						 * a more like a text mode cartoon. 
						 * TInfo1 is used for the width of the file. 
						 * TInfo2 is used to hold the number of ANSi screen lines the 
						 *		ANSiMation was created for. 
						 * A program using SAUCE may use these two values to switch to the 
						 * appropriate video mode. 
						 */
		Rip = 3,		/* Remote Imaging Protocol (RIP) graphics file. 
						 * TInfo1 holds the width (should be 640) 
						 * TInfo2 holds the height (should be 350) 
						 * TInfo3 holds the number of colors (should be 16). 
						 */
		Pcboard = 4,	/* File with PCBoard style @X color codes and @ macro's and ANSi codes. 
						 * TInfo1 is used for the width of the file. 
						 * TInfo2 is used to hold the number of ANSi screen lines in the file. 
						 */
		Avatar = 5,		/* A file with AVATAR and ANSi color codes and cursor positioning. 
						 * TInfo1 is used for the width of the file. 
						 * TInfo2 is used to hold the number of ANSi screen lines 
						 */
		Html = 6,		/* HyperText Markup Language. The type of file used on World Wide Web (WWW). */
		Source = 7		/* A piece of sourcecode for any type of programming language. 
						 * The file extention should determine the programming language (.C=C, .PAS=Pascal, ...) 
						 */
	}

	/// <summary>
	/// Summary description for CharacterDataTypeInfo.
	/// </summary>
	public class CharacterDataTypeInfo : SauceDataTypeInfo
	{
		SauceFlag[] flags;

		public CharacterDataTypeInfo(Sauce sauce) : base(sauce)
		{
			flags = new SauceFlag[] {
										new SauceFlag(sauce, 0, "iCE Colors")
									};
		}

		public CharacterFileType Type
		{
			get 
			{
				return (CharacterFileType)Sauce.ByteFileType;
			}
			set { Sauce.ByteFileType = (byte)value; }
		}

		public override string FileTypeDescription
		{
			get
			{
				return Type.ToString();
			}
		}

		public override string GetTInfoDescription(int info)
		{
			switch (Type)
			{
				case CharacterFileType.Ansi:
				case CharacterFileType.Ansimation:
				case CharacterFileType.Ascii:
				case CharacterFileType.Avatar:
				case CharacterFileType.Pcboard:
					switch (info)
					{
						case 1:	return "Width";
						case 2: return "Height";
					}
					break;
				case CharacterFileType.Rip:
					switch (info)
					{
						case 1:	return "Width";
						case 2: return "Height";
						case 3: return "Colors";
					}
					break;
			}
			return base.GetTInfoDescription(info);
		}

		public override SauceFlag[] Flags
		{
			get
			{
				return flags;
			}
		}


	}
}
