using System;

namespace SimpleXB.Sauce
{
	/// <summary>
	/// Summary description for SauceDataTypeInfo.
	/// </summary>
	public class SauceDataTypeInfo
	{
		private Sauce sauce;
		public SauceDataTypeInfo(Sauce sauce)
		{
			this.sauce = sauce;
		}

		public Sauce Sauce
		{
			get { return sauce; }
		}

		public virtual string FileTypeDescription { get { return string.Empty; } }

		public virtual string GetTInfoDescription(int info)
		{
			return "TInfo" + info; 
		}

		public virtual SauceFlag[] Flags
		{
			get { return new SauceFlag[0]; }
		}

	}
}
