using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using SimpleXB.Sauce;

namespace SimpleXB
{
	/// <summary>
	/// Summary description for SauceInfo.
	/// </summary>
	public class SauceInfo : System.Windows.Forms.Form
	{
		private Sauce.Sauce sauce;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox tbTitle;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox tbGroup;
		private System.Windows.Forms.TextBox tbAuthor;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.TextBox tbDateCreated;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.TextBox tbComments;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button bOk;
		private System.Windows.Forms.TextBox tbDataType;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.TextBox tbFileType;
		private System.Windows.Forms.TextBox tbTInfo2;
		private System.Windows.Forms.TextBox tbTInfo1;
		private System.Windows.Forms.TextBox tbTInfo4;
		private System.Windows.Forms.TextBox tbTInfo3;
		private System.Windows.Forms.Label lTInfo2;
		private System.Windows.Forms.Label lTInfo1;
		private System.Windows.Forms.Label lTInfo4;
		private System.Windows.Forms.Label lTInfo3;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Panel pFlags;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public SauceInfo(Sauce.Sauce sauce)
		{
			this.sauce = sauce;
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			tbTitle.DataBindings.Add("Text", sauce, "Title");
			tbAuthor.DataBindings.Add("Text", sauce, "Author");
			tbGroup.DataBindings.Add("Text", sauce, "Group");
			Binding b = new Binding("Text", sauce, "Date");
			b.Format += new ConvertEventHandler(date_Format);
			tbDateCreated.DataBindings.Add(b);
			tbComments.DataBindings.Add("Lines", sauce, "Comments");

			tbDataType.DataBindings.Add("Text", sauce, "DataType");
			tbFileType.DataBindings.Add("Text", sauce, "FileTypeDescription");

			lTInfo1.DataBindings.Add("Text", sauce, "TInfo1Description");
			lTInfo2.DataBindings.Add("Text", sauce, "TInfo2Description");
			lTInfo3.DataBindings.Add("Text", sauce, "TInfo3Description");
			lTInfo4.DataBindings.Add("Text", sauce, "TInfo4Description");

			tbTInfo1.DataBindings.Add("Text", sauce, "TInfo1");
			tbTInfo2.DataBindings.Add("Text", sauce, "TInfo2");
			tbTInfo3.DataBindings.Add("Text", sauce, "TInfo3");
			tbTInfo4.DataBindings.Add("Text", sauce, "TInfo4");
			

			SauceFlag[] flags = sauce.Flags;
			
			int pos = 0;
			foreach (SauceFlag sf in flags)
			{
				CheckBox cb = new CheckBox();
				cb.Text = sf.Description;
				cb.Checked = sf.Value;
				cb.Width = 100;
				cb.Left = pos;
				cb.AutoCheck = false;
				pFlags.Controls.Add(cb);
				pos += cb.Width;
			}
		}


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.tbTitle = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.tbGroup = new System.Windows.Forms.TextBox();
			this.tbAuthor = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.tbDateCreated = new System.Windows.Forms.TextBox();
			this.tbComments = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.bOk = new System.Windows.Forms.Button();
			this.tbDataType = new System.Windows.Forms.TextBox();
			this.label6 = new System.Windows.Forms.Label();
			this.tbFileType = new System.Windows.Forms.TextBox();
			this.label7 = new System.Windows.Forms.Label();
			this.tbTInfo2 = new System.Windows.Forms.TextBox();
			this.lTInfo2 = new System.Windows.Forms.Label();
			this.tbTInfo1 = new System.Windows.Forms.TextBox();
			this.lTInfo1 = new System.Windows.Forms.Label();
			this.tbTInfo4 = new System.Windows.Forms.TextBox();
			this.lTInfo4 = new System.Windows.Forms.Label();
			this.tbTInfo3 = new System.Windows.Forms.TextBox();
			this.lTInfo3 = new System.Windows.Forms.Label();
			this.label8 = new System.Windows.Forms.Label();
			this.pFlags = new System.Windows.Forms.Panel();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 8);
			this.label1.Name = "label1";
			this.label1.TabIndex = 0;
			this.label1.Text = "Title";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbTitle
			// 
			this.tbTitle.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tbTitle.Location = new System.Drawing.Point(112, 8);
			this.tbTitle.Name = "tbTitle";
			this.tbTitle.ReadOnly = true;
			this.tbTitle.Size = new System.Drawing.Size(280, 20);
			this.tbTitle.TabIndex = 1;
			this.tbTitle.Text = "";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 32);
			this.label2.Name = "label2";
			this.label2.TabIndex = 2;
			this.label2.Text = "Group";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 56);
			this.label3.Name = "label3";
			this.label3.TabIndex = 3;
			this.label3.Text = "Author";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbGroup
			// 
			this.tbGroup.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tbGroup.Location = new System.Drawing.Point(112, 32);
			this.tbGroup.Name = "tbGroup";
			this.tbGroup.ReadOnly = true;
			this.tbGroup.Size = new System.Drawing.Size(280, 20);
			this.tbGroup.TabIndex = 4;
			this.tbGroup.Text = "";
			// 
			// tbAuthor
			// 
			this.tbAuthor.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tbAuthor.Location = new System.Drawing.Point(112, 56);
			this.tbAuthor.Name = "tbAuthor";
			this.tbAuthor.ReadOnly = true;
			this.tbAuthor.Size = new System.Drawing.Size(280, 20);
			this.tbAuthor.TabIndex = 5;
			this.tbAuthor.Text = "";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 80);
			this.label4.Name = "label4";
			this.label4.TabIndex = 6;
			this.label4.Text = "Date Created";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbDateCreated
			// 
			this.tbDateCreated.Location = new System.Drawing.Point(112, 80);
			this.tbDateCreated.Name = "tbDateCreated";
			this.tbDateCreated.ReadOnly = true;
			this.tbDateCreated.Size = new System.Drawing.Size(184, 20);
			this.tbDateCreated.TabIndex = 7;
			this.tbDateCreated.Text = "";
			// 
			// tbComments
			// 
			this.tbComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tbComments.Font = new System.Drawing.Font("Lucida Console", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.tbComments.Location = new System.Drawing.Point(112, 208);
			this.tbComments.Multiline = true;
			this.tbComments.Name = "tbComments";
			this.tbComments.ReadOnly = true;
			this.tbComments.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.tbComments.Size = new System.Drawing.Size(280, 72);
			this.tbComments.TabIndex = 8;
			this.tbComments.Text = "12345678901234567890123456789012345678901234567890123456789012345678901234";
			this.tbComments.WordWrap = false;
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(8, 208);
			this.label5.Name = "label5";
			this.label5.TabIndex = 9;
			this.label5.Text = "Comments";
			this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Location = new System.Drawing.Point(8, 296);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(384, 4);
			this.groupBox1.TabIndex = 10;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "groupBox1";
			// 
			// bOk
			// 
			this.bOk.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.bOk.Location = new System.Drawing.Point(312, 312);
			this.bOk.Name = "bOk";
			this.bOk.TabIndex = 12;
			this.bOk.Text = "&Ok";
			this.bOk.Click += new System.EventHandler(this.bOk_Click);
			// 
			// tbDataType
			// 
			this.tbDataType.Location = new System.Drawing.Point(112, 104);
			this.tbDataType.Name = "tbDataType";
			this.tbDataType.ReadOnly = true;
			this.tbDataType.Size = new System.Drawing.Size(104, 20);
			this.tbDataType.TabIndex = 14;
			this.tbDataType.Text = "";
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(8, 104);
			this.label6.Name = "label6";
			this.label6.TabIndex = 13;
			this.label6.Text = "Data Type";
			this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbFileType
			// 
			this.tbFileType.Location = new System.Drawing.Point(288, 104);
			this.tbFileType.Name = "tbFileType";
			this.tbFileType.ReadOnly = true;
			this.tbFileType.Size = new System.Drawing.Size(104, 20);
			this.tbFileType.TabIndex = 16;
			this.tbFileType.Text = "";
			// 
			// label7
			// 
			this.label7.Location = new System.Drawing.Point(216, 104);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(72, 23);
			this.label7.TabIndex = 15;
			this.label7.Text = "File Type";
			this.label7.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbTInfo2
			// 
			this.tbTInfo2.Location = new System.Drawing.Point(288, 128);
			this.tbTInfo2.Name = "tbTInfo2";
			this.tbTInfo2.ReadOnly = true;
			this.tbTInfo2.Size = new System.Drawing.Size(104, 20);
			this.tbTInfo2.TabIndex = 20;
			this.tbTInfo2.Text = "";
			// 
			// lTInfo2
			// 
			this.lTInfo2.Location = new System.Drawing.Point(216, 128);
			this.lTInfo2.Name = "lTInfo2";
			this.lTInfo2.Size = new System.Drawing.Size(72, 23);
			this.lTInfo2.TabIndex = 19;
			this.lTInfo2.Text = "TInfo 2";
			this.lTInfo2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbTInfo1
			// 
			this.tbTInfo1.Location = new System.Drawing.Point(112, 128);
			this.tbTInfo1.Name = "tbTInfo1";
			this.tbTInfo1.ReadOnly = true;
			this.tbTInfo1.Size = new System.Drawing.Size(104, 20);
			this.tbTInfo1.TabIndex = 18;
			this.tbTInfo1.Text = "";
			// 
			// lTInfo1
			// 
			this.lTInfo1.Location = new System.Drawing.Point(8, 128);
			this.lTInfo1.Name = "lTInfo1";
			this.lTInfo1.TabIndex = 17;
			this.lTInfo1.Text = "TInfo 1";
			this.lTInfo1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbTInfo4
			// 
			this.tbTInfo4.Location = new System.Drawing.Point(288, 152);
			this.tbTInfo4.Name = "tbTInfo4";
			this.tbTInfo4.ReadOnly = true;
			this.tbTInfo4.Size = new System.Drawing.Size(104, 20);
			this.tbTInfo4.TabIndex = 24;
			this.tbTInfo4.Text = "";
			// 
			// lTInfo4
			// 
			this.lTInfo4.Location = new System.Drawing.Point(216, 152);
			this.lTInfo4.Name = "lTInfo4";
			this.lTInfo4.Size = new System.Drawing.Size(72, 23);
			this.lTInfo4.TabIndex = 23;
			this.lTInfo4.Text = "TInfo 4";
			this.lTInfo4.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// tbTInfo3
			// 
			this.tbTInfo3.Location = new System.Drawing.Point(112, 152);
			this.tbTInfo3.Name = "tbTInfo3";
			this.tbTInfo3.ReadOnly = true;
			this.tbTInfo3.Size = new System.Drawing.Size(104, 20);
			this.tbTInfo3.TabIndex = 22;
			this.tbTInfo3.Text = "";
			// 
			// lTInfo3
			// 
			this.lTInfo3.Location = new System.Drawing.Point(8, 152);
			this.lTInfo3.Name = "lTInfo3";
			this.lTInfo3.TabIndex = 21;
			this.lTInfo3.Text = "TInfo 3";
			this.lTInfo3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// label8
			// 
			this.label8.Location = new System.Drawing.Point(8, 176);
			this.label8.Name = "label8";
			this.label8.TabIndex = 25;
			this.label8.Text = "Flags";
			this.label8.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// pFlags
			// 
			this.pFlags.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pFlags.Location = new System.Drawing.Point(112, 176);
			this.pFlags.Name = "pFlags";
			this.pFlags.Size = new System.Drawing.Size(280, 24);
			this.pFlags.TabIndex = 26;
			// 
			// SauceInfo
			// 
			this.AcceptButton = this.bOk;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(400, 340);
			this.Controls.Add(this.pFlags);
			this.Controls.Add(this.label8);
			this.Controls.Add(this.tbTInfo4);
			this.Controls.Add(this.tbTInfo3);
			this.Controls.Add(this.tbTInfo2);
			this.Controls.Add(this.tbTInfo1);
			this.Controls.Add(this.tbFileType);
			this.Controls.Add(this.tbDataType);
			this.Controls.Add(this.tbComments);
			this.Controls.Add(this.tbDateCreated);
			this.Controls.Add(this.tbAuthor);
			this.Controls.Add(this.tbGroup);
			this.Controls.Add(this.tbTitle);
			this.Controls.Add(this.lTInfo4);
			this.Controls.Add(this.lTInfo3);
			this.Controls.Add(this.lTInfo2);
			this.Controls.Add(this.lTInfo1);
			this.Controls.Add(this.label7);
			this.Controls.Add(this.label6);
			this.Controls.Add(this.bOk);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.label5);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.MinimumSize = new System.Drawing.Size(408, 368);
			this.Name = "SauceInfo";
			this.ShowInTaskbar = false;
			this.Text = "Sauce Info";
			this.ResumeLayout(false);

		}
		#endregion

		private void date_Format(object sender, ConvertEventArgs e)
		{
			DateTime dt = (DateTime)e.Value;
			if (e.DesiredType == typeof(string))
			{
				e.Value = dt.ToLongDateString();
			}
		}

		private void bOk_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

	}
}
