{ misc::logon/off announcer::chatX.dat parser }
{ ------------------------------------------- }
{ simply goes through all of the existing chatx.dat files and }
{ checks out which ones are occupied by a user other than the }
{ one who executes it                                         }

{$a+}{$b-}{$d-}{$i-}{$l-}{$r-}
program loganc;
uses crt;

{ taken from mystic's pascal file structures }
type
    chatRec = Record                     { CHATx.DAT }
        Active    : Boolean;               { Is there a user on this node?   }
        Name      : String[30];            { User's name on this node        }
        Action    : String[40];            { User's action on this node      }
        Location  : String[30];            { User's City/State on this node  }
        Gender    : Char;                  { User's gender                   }
        Age       : Byte;                  { User's age                      }
        Baud      : String[6];             { User's baud rate                }
        Invisible : Boolean;               { Is node invisible?              }
        Available : Boolean;               { Is node available?              }
        InChat    : Boolean;               { Is user in multi-node chat?     }
        Room      : Byte;                  { Chat room                       }
    end;

var
    chekLoop    : integer;
    chatData    : file of chatRec;
    chatRecd    : chatRec;
    chatDump    : text;

{ taken from the xdoor door kit  by natedogg }
function  stoi(s: string): longint;
var code: longint; { change this to integer if you're not using vpascal }
    i   : longint;
    begin
        i := 0;
        val(s,i,code);
        stoi := i;
    end;

function itos(n: longint): string;
var v   : string;
    begin
        str(n,v);
        itos := v;
    end;

begin
    clrscr;
    if paramcount <> 3 then
        begin
            writeln('insufficient parameters.  operation halted');
            readkey;
            halt;
        end;

    assign(chatDump,'c:\mystic\scripts\logan.tmp');
    rewrite(chatDump);
        for chekLoop := 1 to stoi(paramstr(3)) do
            begin
                assign(chatData, paramstr(1)+ 'chat' +itos(chekLoop)+ '.dat');
                reset(chatData);
                    read(chatData,chatRecd);
                    if chatRecd.Active then
                        begin
                            if chatRecd.Name <> paramstr(2) then
                                writeln(chatDump,itos(chekLoop));
                        end;
                close(chatData);
            end;
    close(chatDump);

{ paramstr(1)   := path to mystic's data/ directory }
{ paramstr(2)   := current caller's handle          }
{ paramstr(3)   := maximum number of nodes          }
end.
